jui.define("chart.theme.pastel", [], function() {
	var themeColors = [
		"#73e9d2",
		"#fef92c",
		"#ff9248",
		"#b7eef6",
		"#08c4e0",
		"#ffb9ce",
		"#ffd4ba",
		"#14be9d",
		"#ebebeb",
		"#666666",
		"#cdbfe3",
		"#bee982",
		"#c22269"
	];

	return {
		fontFamily : "Caslon540BT-Regular,Times,New Roman,serif",
		backgroundColor : "white",
		colors : themeColors,

		// Grid styles
		gridXFontSize : 11,
		gridYFontSize : 11,
		gridCFontSize : 11,
		gridXFontColor : "#333",
		gridYFontColor : "#333",
		gridCFontColor : "#333",
		gridXFontWeight : "normal",
		gridYFontWeight : "normal",
		gridCFontWeight : "normal",
		gridXAxisBorderColor : "#bfbfbf",
		gridYAxisBorderColor : "#bfbfbf",
		gridXAxisBorderWidth : 2,
		gridYAxisBorderWidth : 2,

		gridActiveFontColor : "#ff7800",
		gridActiveBorderColor : "#ff7800",
		gridPatternColor : "#ababab",
		gridPatternOpacity : 0.1,
		gridBorderColor : "#bfbfbf",
		gridBorderWidth : 1,
		gridBorderDashArray : "1, 3",
		gridBorderOpacity : 1,
		gridTickBorderSize : 3,
		gridTickBorderWidth : 1.5,
		gridTickPadding : 5,

		// Brush styles
		tooltipPointRadius : 5, // common
		tooltipPointBorderWidth : 1, // common
		tooltipPointFontWeight : "bold", // common
		tooltipPointFontSize : 11,
		barFontSize : 11,
		barFontColor : "#333",
		barBorderColor : "none",
		barBorderWidth : 0,
		barBorderOpacity : 0,
		barBorderRadius : 3,
		barActiveBackgroundColor : "#ffb9ce",
		barPointBorderColor : "#ebebeb",
		barDisableBackgroundOpacity : 0.4,
		gaugeBackgroundColor : "#f5f5f5",
        gaugeArrowColor : "gray",
		gaugeFontColor : "#666666",
        gaugeFontSize : 20,
        gaugeFontWeight : "bold",
        gaugeTitleFontSize : 12,
        gaugeTitleFontWeight : "normal",
        gaugeTitleFontColor : "#333",
        bargaugeBackgroundColor : "#f5f5f5",
        bargaugeFontSize : 11,
        bargaugeFontColor : "#333333",
		pieBorderColor : "white",
		pieBorderWidth : 1,
        pieOuterFontSize : 11,
        pieOuterLineColor : "#a9a9a9",
        pieOuterLineSize : 8,
        pieOuterLineRate : 1.3,
        pieActiveDistance : 5,
		areaBackgroundOpacity : 0.4,
		areaSplitBackgroundColor : "#ebebeb",
		bubbleBackgroundOpacity : 0.5,
		bubbleBorderWidth : 1,
		candlestickBorderColor : "#14be9d",
		candlestickBackgroundColor : "#14be9d",
		candlestickInvertBorderColor : "#ff4848",
		candlestickInvertBackgroundColor : "#ff4848",
        ohlcBorderColor : "#14be9d",
        ohlcInvertBorderColor : "#ff4848",
        ohlcBorderRadius : 5,
		lineBorderWidth : 2,
        lineBorderDashArray : "none",
		lineDisableBorderOpacity : 0.3,
		linePointBorderColor : "white",
		lineSplitBorderColor : null,
		lineSplitBorderOpacity : 0.5,
		pathBackgroundOpacity : 0.5,
		pathBorderWidth : 1,
		scatterBorderColor : "white",
		scatterBorderWidth : 1,
		scatterHoverColor : "white",
		waterfallBackgroundColor : "#73e9d2",
		waterfallInvertBackgroundColor : "#ffb9ce",
		waterfallEdgeBackgroundColor : "#08c4e0",
		waterfallLineColor : "#a9a9a9",
		waterfallLineDashArray : "0.9",
		focusBorderColor : "#FF7800",
		focusBorderWidth : 1,
		focusBackgroundColor : "#FF7800",
		focusBackgroundOpacity : 0.1,
		pinFontColor : "#FF7800",
		pinFontSize : 10,
		pinBorderColor : "#FF7800",
		pinBorderWidth : 0.7,

        topologyNodeRadius : 12.5,
        topologyNodeFontSize : 14,
        topologyNodeFontColor : "white",
        topologyNodeTitleFontSize : 11,
        topologyNodeTitleFontColor : "#333",
        topologyEdgeColor : "#b2b2b2",
        topologyActiveEdgeColor : "#905ed1",
        topologyEdgeFontSize : 10,
        topologyEdgeFontColor : "#666",
        topologyEdgePointRadius : 3,
        topologyTooltipBackgroundColor : "white",
        topologyTooltipBorderColor : "#ccc",
        topologyTooltipFontSize : 11,
        topologyTooltipFontColor : "#333",

        // widget styles
        titleFontColor : "#333",
        titleFontSize : 18,
		titleFontWeight : "normal",
        legendFontColor : "#333",
        legendFontSize : 11,
		legendSwitchCircleColor : "white",
		legendSwitchDisableColor : "#c8c8c8",
        tooltipFontColor : "#fff",
        tooltipFontSize : 12,
        tooltipBackgroundColor : "black",
		tooltipBackgroundOpacity : 0.7,
        tooltipBorderColor : null,
		tooltipBorderWidth : 2,
		tooltipLineColor : null,
		tooltipLineWidth : 1,
        scrollBackgroundSize : 7,
		scrollBackgroundColor :	"#f5f5f5",
		scrollThumbBackgroundColor : "#b2b2b2",
		scrollThumbBorderColor : "#9f9fa4",
		zoomBackgroundColor : "red",
		zoomFocusColor : "gray",
        zoomScrollBackgroundSize : 50,
        zoomScrollBackgroundColor : "#000",
        zoomScrollFocusColor : "#fff",
        zoomScrollBrushColor : "#000",
		crossBorderColor : "#a9a9a9",
		crossBorderWidth : 1,
		crossBorderOpacity : 0.8,
		crossBalloonFontSize : 11,
		crossBalloonFontColor :	"white",
		crossBalloonBackgroundColor : "black",
		crossBalloonBackgroundOpacity : 0.7,
		dragSelectBackgroundColor : "#7BBAE7",
		dragSelectBackgroundOpacity : 0.3,
		dragSelectBorderColor : "#7BBAE7",
		dragSelectBorderWidth : 1,

		// Map Common
		mapPathBackgroundColor : "#67B7DC",
		mapPathBackgroundOpacity : 1,
		mapPathBorderColor : "white",
		mapPathBorderWidth : 1,
		mapPathBorderOpacity : 1,
		// Map Brushes
		mapBubbleBackgroundOpacity : 0.5,
		mapBubbleBorderWidth : 1,
		mapBubbleFontSize : 11,
		mapBubbleFontColor : "white",
		mapSelectorHoverColor : "#5a73db",
		mapSelectorActiveColor : "#CC0000",
		mapFlightRouteAirportSmallColor : "#CC0000",
		mapFlightRouteAirportLargeColor : "#000",
		mapFlightRouteAirportBorderWidth : 2,
		mapFlightRouteAirportRadius : 8,
		mapFlightRouteLineColor : "red",
		mapFlightRouteLineWidth : 1,
		mapWeatherBackgroundColor : "white",
		mapWeatherBorderColor : "#a9a9a9",
		mapWeatherFontSize : 11,
		mapWeatherTitleFontColor : "#666",
		mapWeatherInfoFontColor : "red",
		mapCompareBubbleMaxLineColor : "#fff",
		mapCompareBubbleMaxLineDashArray : "2,2",
		mapCompareBubbleMaxBorderColor : "#fff",
		mapCompareBubbleMaxFontSize : 36,
		mapCompareBubbleMaxFontColor : "#fff",
		mapCompareBubbleMinBorderColor : "#ffff00",
		mapCompareBubbleMinFontSize : 24,
		mapCompareBubbleMinFontColor : "#000",
		// Map Widgets
		mapControlButtonColor : "#3994e2",
		mapControlScrollColor : "#000",
		mapControlScrollLineColor : "#fff"
	}
}); 