/* 
 * Leaflet Control Search v1.8.3 - 2015-09-03 
 * 
 * Copyright 2015 Stefano Cudini 
 * stefano.cudini@gmail.com 
 * http://labs.easyblog.it/ 
 * 
 * Licensed under the MIT license. 
 * 
 * Demo: 
 * http://labs.easyblog.it/maps/leaflet-search/ 
 * 
 * Source: 
 * git@github.com:stefanocudini/leaflet-search.git 
 * 
 */
(function(){L.Control.Search=L.Control.extend({includes:L.Mixin.Events,options:{layer:null,sourceData:null,url:"",jsonpParam:null,propertyName:"title",propertyLoc:"loc",formatData:null,filterData:null,callTip:null,container:"",minLength:1,initial:!0,casesesitive:!1,autoType:!0,delayType:400,tooltipLimit:-1,tipAutoSubmit:!0,autoResize:!0,collapsed:!0,autoCollapse:!1,autoCollapseTime:1200,zoom:null,position:"topleft",textErr:"Location not found",textCancel:"Cancel",textPlaceholder:"Search...",animateLocation:!0,circleLocation:!0,markerLocation:!1,markerIcon:new L.Icon.Default},initialize:function(a){L.Util.setOptions(this,a||{}),this._inputMinSize=this.options.textPlaceholder?this.options.textPlaceholder.length:10,this._layer=this.options.layer||new L.LayerGroup,this._filterData=this.options.filterData||this._defaultFilterData,this._formatData=this.options.formatData||this._defaultFormatData,this._autoTypeTmp=this.options.autoType,this._countertips=0,this._recordsCache={},this._curReq=null},onAdd:function(a){return this._map=a,this._container=L.DomUtil.create("div","leaflet-control-search"),this._input=this._createInput(this.options.textPlaceholder,"search-input"),this._tooltip=this._createTooltip("search-tooltip"),this._cancel=this._createCancel(this.options.textCancel,"search-cancel"),this._button=this._createButton(this.options.textPlaceholder,"search-button"),this._alert=this._createAlert("search-alert"),this.options.collapsed===!1&&this.expand(this.options.collapsed),(this.options.circleLocation||this.options.markerLocation||this.options.markerIcon)&&(this._markerLoc=new L.Control.Search.Marker([0,0],{showCircle:this.options.circleLocation,showMarker:this.options.markerLocation,icon:this.options.markerIcon})),this.setLayer(this._layer),a.on({resize:this._handleAutoresize},this),this._container},addTo:function(a){return this.options.container?(this._container=this.onAdd(a),this._wrapper=L.DomUtil.get(this.options.container),this._wrapper.style.position="relative",this._wrapper.appendChild(this._container)):L.Control.prototype.addTo.call(this,a),this},onRemove:function(a){this._recordsCache={}},_getPath:function(a,b){var c=b.split("."),d=c.pop(),e=c.length,f=c[0],g=1;if(e>0)for(;(a=a[f])&&e>g;)f=c[g++];return a?a[d]:void 0},setLayer:function(a){return this._layer=a,this._layer.addTo(this._map),this._markerLoc&&this._layer.addLayer(this._markerLoc),this},showAlert:function(a){a=a||this.options.textErr,this._alert.style.display="block",this._alert.innerHTML=a,clearTimeout(this.timerAlert);var b=this;return this.timerAlert=setTimeout(function(){b.hideAlert()},this.options.autoCollapseTime),this},hideAlert:function(){return this._alert.style.display="none",this},cancel:function(){return this._input.value="",this._handleKeypress({keyCode:8}),this._input.size=this._inputMinSize,this._input.focus(),this._cancel.style.display="none",this._hideTooltip(),this},expand:function(a){return a="boolean"==typeof a?a:!0,this._input.style.display="block",L.DomUtil.addClass(this._container,"search-exp"),a!==!1&&(this._input.focus(),this._map.on("dragstart click",this.collapse,this)),this.fire("search_expanded"),this},collapse:function(){return this._hideTooltip(),this.cancel(),this._alert.style.display="none",this._input.blur(),this.options.collapsed&&(this._input.style.display="none",this._cancel.style.display="none",L.DomUtil.removeClass(this._container,"search-exp"),this._map.off("dragstart click",this.collapse,this)),this.fire("search_collapsed"),this},collapseDelayed:function(){if(!this.options.autoCollapse)return this;var a=this;return clearTimeout(this.timerCollapse),this.timerCollapse=setTimeout(function(){a.collapse()},this.options.autoCollapseTime),this},collapseDelayedStop:function(){return clearTimeout(this.timerCollapse),this},_createAlert:function(a){var b=L.DomUtil.create("div",a,this._container);return b.style.display="none",L.DomEvent.on(b,"click",L.DomEvent.stop,this).on(b,"click",this.hideAlert,this),b},_createInput:function(a,b){var c=L.DomUtil.create("label",b,this._container),d=L.DomUtil.create("input",b,this._container);return d.type="text",d.size=this._inputMinSize,d.value="",d.autocomplete="off",d.autocorrect="off",d.autocapitalize="off",d.placeholder=a,d.style.display="none",d.role="search",d.id=d.role+d.type+d.size,c.htmlFor=d.id,c.style.display="none",c.value=a,L.DomEvent.disableClickPropagation(d).on(d,"keyup",this._handleKeypress,this).on(d,"keydown",this._handleAutoresize,this).on(d,"blur",this.collapseDelayed,this).on(d,"focus",this.collapseDelayedStop,this),d},_createCancel:function(a,b){var c=L.DomUtil.create("a",b,this._container);return c.href="#",c.title=a,c.style.display="none",c.innerHTML="<span>&otimes;</span>",L.DomEvent.on(c,"click",L.DomEvent.stop,this).on(c,"click",this.cancel,this),c},_createButton:function(a,b){var c=L.DomUtil.create("a",b,this._container);return c.href="#",c.title=a,L.DomEvent.on(c,"click",L.DomEvent.stop,this).on(c,"click",this._handleSubmit,this).on(c,"focus",this.collapseDelayedStop,this).on(c,"blur",this.collapseDelayed,this),c},_createTooltip:function(a){var b=L.DomUtil.create("ul",a,this._container);b.style.display="none";var c=this;return L.DomEvent.disableClickPropagation(b).on(b,"blur",this.collapseDelayed,this).on(b,"mousewheel",function(a){c.collapseDelayedStop(),L.DomEvent.stopPropagation(a)},this).on(b,"mouseover",function(a){c.collapseDelayedStop()},this),b},_createTip:function(a,b){var c;if(this.options.callTip){if(c=this.options.callTip(a,b),"string"==typeof c){var d=L.DomUtil.create("div");d.innerHTML=c,c=d.firstChild}}else c=L.DomUtil.create("li",""),c.innerHTML=a;return L.DomUtil.addClass(c,"search-tip"),c._text=a,L.DomEvent.disableClickPropagation(c).on(c,"click",L.DomEvent.stop,this).on(c,"click",function(b){this._input.value=a,this._handleAutoresize(),this._input.focus(),this._hideTooltip(),this.options.tipAutoSubmit&&this._handleSubmit()},this),c},_getUrl:function(a){return"function"==typeof this.options.url?this.options.url(a):this.options.url},_defaultFilterData:function(a,b){var c,d,e=new RegExp("^[.]$|[[]|()*]","g"),f={};a=a.replace(e,""),c=this.options.initial?"^":"",d=new RegExp(c+a,this.options.casesesitive?void 0:"i");for(var g in b)d.test(g)&&(f[g]=b[g]);return f},showTooltip:function(a){var b;this._countertips=0,this._tooltip.innerHTML="",this._tooltip.currentSelection=-1;for(var c in a){if(++this._countertips==this.options.tooltipLimit)break;b=this._createTip(c,a[c]),this._tooltip.appendChild(b)}return this._countertips>0?(this._tooltip.style.display="block",this._autoTypeTmp&&this._autoType(),this._autoTypeTmp=this.options.autoType):this._hideTooltip(),this._tooltip.scrollTop=0,this._countertips},_hideTooltip:function(){return this._tooltip.style.display="none",this._tooltip.innerHTML="",0},_defaultFormatData:function(a){var b,c=this.options.propertyName,d=this.options.propertyLoc,e={};if(L.Util.isArray(d))for(b in a)e[this._getPath(a[b],c)]=L.latLng(a[b][d[0]],a[b][d[1]]);else for(b in a)e[this._getPath(a[b],c)]=L.latLng(this._getPath(a[b],d));return e},_recordsFromJsonp:function(a,b){L.Control.Search.callJsonp=b;var c=L.DomUtil.create("script","leaflet-search-jsonp",document.getElementsByTagName("body")[0]),d=L.Util.template(this._getUrl(a)+"&"+this.options.jsonpParam+"=L.Control.Search.callJsonp",{s:a});return c.type="text/javascript",c.src=d,{abort:function(){c.parentNode.removeChild(c)}}},_recordsFromAjax:function(a,b){void 0===window.XMLHttpRequest&&(window.XMLHttpRequest=function(){try{return new ActiveXObject("Microsoft.XMLHTTP.6.0")}catch(a){try{return new ActiveXObject("Microsoft.XMLHTTP.3.0")}catch(b){throw new Error("XMLHttpRequest is not supported")}}});var c=L.Browser.ie&&!window.atob&&document.querySelector,d=c?new XDomainRequest:new XMLHttpRequest,e=L.Util.template(this._getUrl(a),{s:a});d.open("GET",e);return d.onload=function(){b(JSON.parse(d.responseText))},d.onreadystatechange=function(){4===d.readyState&&200===d.status&&this.onload()},d.send(),d},_recordsFromLayer:function(){var a,b=this,c={},d=this.options.propertyName;return this._layer.eachLayer(function(e){if(!(e instanceof L.Control.Search.Marker))if(e instanceof L.Marker||e instanceof L.CircleMarker)if(b._getPath(e.options,d))a=e.getLatLng(),a.layer=e,c[b._getPath(e.options,d)]=a;else{if(!b._getPath(e.feature.properties,d))throw new Error("propertyName '"+d+"' not found in marker");a=e.getLatLng(),a.layer=e,c[b._getPath(e.feature.properties,d)]=a}else if(e.hasOwnProperty("feature")){if(!e.feature.properties.hasOwnProperty(d))throw new Error("propertyName '"+d+"' not found in feature");a=e.getBounds().getCenter(),a.layer=e,c[e.feature.properties[d]]=a}else e instanceof L.LayerGroup&&e.eachLayer(function(b){a=b.getLatLng(),a.layer=b,c[b.feature.properties[d]]=a})},this),c},_autoType:function(){var a=this._input.value.length,b=this._tooltip.firstChild._text,c=b.length;if(0===b.indexOf(this._input.value))if(this._input.value=b,this._handleAutoresize(),this._input.createTextRange){var d=this._input.createTextRange();d.collapse(!0),d.moveStart("character",a),d.moveEnd("character",c),d.select()}else this._input.setSelectionRange?this._input.setSelectionRange(a,c):this._input.selectionStart&&(this._input.selectionStart=a,this._input.selectionEnd=c)},_hideAutoType:function(){var a;if((a=this._input.selection)&&a.empty)a.empty();else if(this._input.createTextRange){a=this._input.createTextRange(),a.collapse(!0);var b=this._input.value.length;a.moveStart("character",b),a.moveEnd("character",b),a.select()}else this._input.getSelection&&this._input.getSelection().removeAllRanges(),this._input.selectionStart=this._input.selectionEnd},_handleKeypress:function(a){switch(a.keyCode){case 27:this.collapse();break;case 13:1==this._countertips&&this._handleArrowSelect(1),this._handleSubmit();break;case 38:this._handleArrowSelect(-1);break;case 40:this._handleArrowSelect(1);break;case 37:case 39:case 16:case 17:break;case 8:case 46:this._autoTypeTmp=!1;break;default:if(this._input.value.length?this._cancel.style.display="block":this._cancel.style.display="none",this._input.value.length>=this.options.minLength){var b=this;clearTimeout(this.timerKeypress),this.timerKeypress=setTimeout(function(){b._fillRecordsCache()},this.options.delayType)}else this._hideTooltip()}},searchText:function(a){var b=a.charCodeAt(a.length);this._input.value=a,this._input.style.display="block",L.DomUtil.addClass(this._container,"search-exp"),this._autoTypeTmp=!1,this._handleKeypress({keyCode:b})},_fillRecordsCache:function(){var a,b=this._input.value,c=this;this._curReq&&this._curReq.abort&&this._curReq.abort(),L.DomUtil.addClass(this._container,"search-load"),this.options.layer?(this._recordsCache=this._recordsFromLayer(),a=this._filterData(this._input.value,this._recordsCache),this.showTooltip(a),L.DomUtil.removeClass(this._container,"search-load")):(this.options.sourceData?this._retrieveData=this.options.sourceData:this.options.url&&(this._retrieveData=this.options.jsonpParam?this._recordsFromJsonp:this._recordsFromAjax),this._curReq=this._retrieveData.call(this,b,function(b){c._recordsCache=c._formatData(b),a=c.options.sourceData?c._filterData(c._input.value,c._recordsCache):c._recordsCache,c.showTooltip(a),L.DomUtil.removeClass(c._container,"search-load")}))},_handleAutoresize:function(){this._input.style.maxWidth!=this._map._container.offsetWidth&&(this._input.style.maxWidth=L.DomUtil.getStyle(this._map._container,"width")),this.options.autoResize&&this._container.offsetWidth+45<this._map._container.offsetWidth&&(this._input.size=this._input.value.length<this._inputMinSize?this._inputMinSize:this._input.value.length)},_handleArrowSelect:function(a){var b=this._tooltip.hasChildNodes()?this._tooltip.childNodes:[];for(i=0;i<b.length;i++)L.DomUtil.removeClass(b[i],"search-tip-select");if(1==a&&this._tooltip.currentSelection>=b.length-1)L.DomUtil.addClass(b[this._tooltip.currentSelection],"search-tip-select");else if(-1==a&&this._tooltip.currentSelection<=0)this._tooltip.currentSelection=-1;else if("none"!=this._tooltip.style.display){this._tooltip.currentSelection+=a,L.DomUtil.addClass(b[this._tooltip.currentSelection],"search-tip-select"),this._input.value=b[this._tooltip.currentSelection]._text;var c=b[this._tooltip.currentSelection].offsetTop;c+b[this._tooltip.currentSelection].clientHeight>=this._tooltip.scrollTop+this._tooltip.clientHeight?this._tooltip.scrollTop=c-this._tooltip.clientHeight+b[this._tooltip.currentSelection].clientHeight:c<=this._tooltip.scrollTop&&(this._tooltip.scrollTop=c)}},_handleSubmit:function(){if(this._hideAutoType(),this.hideAlert(),this._hideTooltip(),"none"==this._input.style.display)this.expand();else if(""===this._input.value)this.collapse();else{var a=this._getLocation(this._input.value);a===!1?this.showAlert():(this.showLocation(a,this._input.value),this.fire("search_locationfound",{latlng:a,text:this._input.value,layer:a.layer?a.layer:null}))}},_getLocation:function(a){return this._recordsCache.hasOwnProperty(a)?this._recordsCache[a]:!1},showLocation:function(a,b){return this.options.zoom?this._map.setView(a,this.options.zoom):this._map.panTo(a),this._markerLoc&&(this._markerLoc.setLatLng(a),this._markerLoc.setTitle(b),this._markerLoc.show(),this.options.animateLocation&&this._markerLoc.animate()),this.options.autoCollapse&&this.collapse(),this}}),L.Control.Search.Marker=L.Marker.extend({includes:L.Mixin.Events,options:{radius:10,weight:3,color:"#e03",stroke:!0,fill:!1,title:"",icon:new L.Icon.Default,showCircle:!0,showMarker:!1},initialize:function(a,b){L.setOptions(this,b),L.Marker.prototype.initialize.call(this,a,b),this.options.showCircle&&(this._circleLoc=new L.CircleMarker(a,this.options))},onAdd:function(a){L.Marker.prototype.onAdd.call(this,a),this._circleLoc&&a.addLayer(this._circleLoc),this.hide()},onRemove:function(a){L.Marker.prototype.onRemove.call(this,a),this._circleLoc&&a.removeLayer(this._circleLoc)},setLatLng:function(a){return L.Marker.prototype.setLatLng.call(this,a),this._circleLoc&&this._circleLoc.setLatLng(a),this},setTitle:function(a){return a=a||"",this.options.title=a,this._icon&&(this._icon.title=a),this},show:function(){return this.options.showMarker&&(this._icon&&(this._icon.style.display="block"),this._shadow&&(this._shadow.style.display="block")),this._circleLoc&&this._circleLoc.setStyle({fill:this.options.fill,stroke:this.options.stroke}),this},hide:function(){return this._icon&&(this._icon.style.display="none"),this._shadow&&(this._shadow.style.display="none"),this._circleLoc&&this._circleLoc.setStyle({fill:!1,stroke:!1}),this},animate:function(){if(this._circleLoc){var a=this._circleLoc,b=200,c=10,d=parseInt(a._radius/c),e=this.options.radius,f=2.5*a._radius,g=0;a._timerAnimLoc=setInterval(function(){g+=.5,d+=g,f-=d,a.setRadius(f),e>f&&(clearInterval(a._timerAnimLoc),a.setRadius(e))},b)}return this}}),L.Map.addInitHook(function(){this.options.searchControl&&(this.searchControl=L.control.search(this.options.searchControl),this.addControl(this.searchControl))}),L.control.search=function(a){return new L.Control.Search(a)}}).call(this);