---
layout: v2
title: Tutorials
bodyclass: examples
---

## Leaflet Tutorials

Every tutorial here comes with step-by-step code explanation and is easy enough even for beginner JavaScript developers.

***
[<img src="docs/images/quick-start.png" class="example-img bordered-img" />][1]

### [Leaflet Quick Start Guide][1]

A simple step-by-step guide that will quickly get you started with Leaflet basics, including setting up a Leaflet map (with Mapbox tiles) on your page, working with markers, polylines and popups, and dealing with events.

***
[<img src="docs/images/mobile.png" class="example-img" />][2]

### [Leaflet on Mobile][2]

In this tutorial, you'll learn how to create a fullscreen map tuned for mobile devices like iPhone, iPad or Android phones, and how to easily detect and use the current user location.

***
[<img src="docs/images/custom-icons.png" class="example-img bordered-img" />][3]

### [Markers with Custom Icons][3]

In this pretty tutorial, you'll learn how to easily define your own icons for use by the markers you put on the map.

***
[<img src="docs/images/geojson.png" class="example-img bordered-img" />][4]

### [Using GeoJSON with Leaflet][4]

In this tutorial, you'll learn how to create and interact with map vectors created from [GeoJSON][5] objects.

***
[<img src="docs/images/choropleth.png" class="example-img bordered-img" />][7]

### [Interactive Choropleth Map][7]

A case study of creating a colorful interactive [choropleth map](http://en.wikipedia.org/wiki/Choropleth_map) of US States Population Density with GeoJSON and some custom controls. News websites will love this.

***
[<img src="docs/images/layers-control.png" class="example-img bordered-img" />][6]

### [Layer Groups and Layers Control][6]

A tutorial on how to manage groups of layers and use the layer switching control.

***
[<img src="examples/crs-simple/thumbnail.png" class="example-img bordered-img" />][9]

### [Non-geographical maps][9]

A primer on `L.CRS.Simple`, how to make maps with no concept of "latitude" or "longitude".


***
[<img src="examples/wms/thumbnail.png" class="example-img bordered-img" />][10]

### [WMS and TMS][10]

How to integrate with WMS and TMS services from professional GIS software.


***

The following tutorials use features available **only in Leaflet 1.0**:

***
[<img src="docs/images/labels-pane.png" class="example-img bordered-img" />][8]

### [Working with map panes][8]

How the default map panes work to display overlays on top of tiles, and how to override that.

<!--***
<h3><a class="noimpl" href="#">Custom Controls</a></h3>

A brief tutorial on implementing custom map controls.

***
<h3><a class="noimpl" href="#">Custom Overlays</a></h3>

If markers, popups and vectors are not enough for you, here's a guide for creating your own map overlays (things to put on a map).
-->

***
If you find that an important tutorial is missing here, let us know!

 [1]: examples/quick-start.html
 [2]: examples/mobile.html
 [3]: examples/custom-icons.html
 [4]: examples/geojson.html
 [5]: http://geojson.org/
 [6]: examples/layers-control.html
 [7]: examples/choropleth.html
 [8]: examples/map-panes.html
 [9]: examples/crs-simple/crs-simple.html
 [10]: examples/wms/wms.html
