# List.js
Perfect library for adding **search**, **sort**, **filters** and **flexibility** to
**tables**, **lists** and various HTML elements. Built to be invisible and work on existing HTML.
Really simple and easy to use!

[![Donate](https://s3.amazonaws.com/listjs/donate-coffee.png)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=M7ZGHV75VSD2E)
[![CircleCI](https://circleci.com/gh/javve/list.js/tree/master.svg?style=shield)](https://circleci.com/gh/javve/list.js/tree/master)
[![codecov](https://codecov.io/gh/javve/list.js/branch/master/graph/badge.svg)](https://codecov.io/gh/javve/list.js)

### Core idea
- Simple and invisible
- Easy to apply to existing HTML
- No dependencies
- Fast
- Small
- Handle thousands of items

### Features
- Works both lists, tables and almost anything else. E.g. `<div>`,`<ul>`,`<table>`, etc.
- Search [Read more ›](http://listjs.com/docs/list-api#search)
- Sort [Read more ›](http://listjs.com/docs/list-api#sort)
- Filter [Read more ›](http://listjs.com/docs/list-api#filter)
- Simple templating system that adds possibility to add, edit, remove items [Read more ›](http://listjs.com/docs/list-api#add)
- Plugins [Read more ›](http://listjs.com/docs/plugins)
- Support for Chrome, Safari, Firefox, IE6+

### Download / Install
##### Via Bower
```
bower install list.js
```
##### Via NPM
```
npm install list.js
```
##### Via CDNJS
```html
<script src="//cdnjs.cloudflare.com/ajax/libs/list.js/1.4.1/list.min.js"></script>
```
##### Via Direct Download
- [Compressed list.js](https://raw.githubusercontent.com/javve/list.js/v1.4.1/dist/list.min.js)
- [Uncompressed list.js](https://raw.githubusercontent.com/javve/list.js/v1.4.1/dist/list.js)

### Demo / Examples
- [Existing list](http://listjs.com/examples/existing-list)
- [Existing list + add](http://listjs.com/examples/existing-list-add)
- [New list](http://listjs.com/examples/new-list)
- [Add, get, remove](http://listjs.com/examples/add-get-remove)
- [Fuzzy search](http://listjs.com/examples/fuzzy-search)
- [Pagination](http://listjs.com/examples/pagination)
- [Search in specific column](http://codepen.io/javve/pen/GpZpow)
- [Filter in range](http://codepen.io/javve/pen/wKGKWL)
- [Show message filter/search results in 0 items](http://codepen.io/javve/pen/VvavzG)
- [Only show list after search/filter](http://codepen.io/javve/pen/YyqyRg)

## Documentation
- [Getting started](http://listjs.com/docs)
- [Options](http://listjs.com/docs/options)
- [List API](http://listjs.com/docs/list-api)
- [Item API](http://listjs.com/docs/item-api)
- [Changelog](http://listjs.com/overview/changelog)

### Plugins
- [Introduction](http://listjs.com/docs/plugins)
- [Pagination](http://listjs.com/docs/plugins/pagination)
- [Fuzzy search](http://listjs.com/docs/plugins/fuzzysearch)
- [Build your own](http://listjs.com/docs/plugins/build)

### Thanks to [all lovely contributors](https://github.com/javve/list.js/graphs/contributors)! Want to join them?
- Read more at [listjs.com/overview/contribute](http://listjs.com/overview/contribute)

### Creator
|               | Jonny Strömberg [@javve](http://twitter.com/javve)            |
| ------------- | ------------- |
| ![Image of Jonny](http://1.gravatar.com/avatar/9f8130715cb4c452f1294eafa1b36290?size=80) | I hope you like the lib. I’ve put a lot of hours into it! Feel free to follow me on [Twitter](http://twitter.com/javve) for news and [donate a coffee](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=M7ZGHV75VSD2E) for good karma ;)  


## License (MIT)

Copyright (c) 2012-2017 Jonny Strömberg <[jonny.stromberg@gmail.com](mailto:jonny.stromberg@gmail.com)>
[http://javve.com](http://javve.com)
