define(['../internal/baseAt', '../internal/baseFlatten', '../internal/isArrayLike', '../function/restParam', '../internal/toIterable'], function(baseAt, baseFlatten, isArrayLike, restParam, toIterable) {

  /**
   * Creates an array of elements corresponding to the given keys, or indexes,
   * of `collection`. Keys may be specified as individual arguments or as arrays
   * of keys.
   *
   * @static
   * @memberOf _
   * @category Collection
   * @param {Array|Object|string} collection The collection to iterate over.
   * @param {...(number|number[]|string|string[])} [props] The property names
   *  or indexes of elements to pick, specified individually or in arrays.
   * @returns {Array} Returns the new array of picked elements.
   * @example
   *
   * _.at(['a', 'b', 'c'], [0, 2]);
   * // => ['a', 'c']
   *
   * _.at(['barney', 'fred', 'pebbles'], 0, 2);
   * // => ['barney', 'pebbles']
   */
  var at = restParam(function(collection, props) {
    if (isArrayLike(collection)) {
      collection = toIterable(collection);
    }
    return baseAt(collection, baseFlatten(props));
  });

  return at;
});
