define(['./baseCallback', './baseFindIndex'], function(baseCallback, baseFindIndex) {

  /**
   * Creates a `_.findIndex` or `_.findLastIndex` function.
   *
   * @private
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {Function} Returns the new find function.
   */
  function createFindIndex(fromRight) {
    return function(array, predicate, thisArg) {
      if (!(array && array.length)) {
        return -1;
      }
      predicate = baseCallback(predicate, thisArg, 3);
      return baseFindIndex(array, predicate, fromRight);
    };
  }

  return createFindIndex;
});
