define(['./internal/baseExtremum', './internal/baseIteratee', './gt'], function(baseExtremum, baseIteratee, gt) {

  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
  var undefined;

  /**
   * This method is like `_.max` except that it accepts `iteratee` which is
   * invoked for each element in `array` to generate the criterion by which
   * the value is ranked. The iteratee is invoked with one argument: (value).
   *
   * @static
   * @memberOf _
   * @category Math
   * @param {Array} array The array to iterate over.
   * @param {Function|Object|string} [iteratee=_.identity] The iteratee invoked per element.
   * @returns {*} Returns the maximum value.
   * @example
   *
   * var objects = [{ 'n': 1 }, { 'n': 2 }];
   *
   * _.maxBy(objects, function(o) { return o.a; });
   * // => { 'n': 2 }
   *
   * // using the `_.property` iteratee shorthand
   * _.maxBy(objects, 'n');
   * // => { 'n': 2 }
   */
  function maxBy(array, iteratee) {
    return (array && array.length)
      ? baseExtremum(array, baseIteratee(iteratee), gt)
      : undefined;
  }

  return maxBy;
});
