define(['./internal/charsEndIndex', './internal/stringToArray', './toString'], function(charsEndIndex, stringToArray, toString) {

  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
  var undefined;

  /** Used to match leading and trailing whitespace. */
  var reTrimEnd = /\s+$/;

  /**
   * Removes trailing whitespace or specified characters from `string`.
   *
   * @static
   * @memberOf _
   * @category String
   * @param {string} [string=''] The string to trim.
   * @param {string} [chars=whitespace] The characters to trim.
   * @param- {Object} [guard] Enables use as an iteratee for functions like `_.map`.
   * @returns {string} Returns the trimmed string.
   * @example
   *
   * _.trimEnd('  abc  ');
   * // => '  abc'
   *
   * _.trimEnd('-_-abc-_-', '_-');
   * // => '-_-abc'
   */
  function trimEnd(string, chars, guard) {
    string = toString(string);
    if (!string) {
      return string;
    }
    if (guard || chars === undefined) {
      return string.replace(reTrimEnd, '');
    }
    chars = (chars + '');
    if (!chars) {
      return string;
    }
    var strSymbols = stringToArray(string);
    return strSymbols.slice(0, charsEndIndex(strSymbols, stringToArray(chars)) + 1).join('');
  }

  return trimEnd;
});
