define(['./internal/arrayFilter', './internal/baseXor', './isArrayLikeObject', './rest'], function(arrayFilter, baseXor, isArrayLikeObject, rest) {

  /**
   * Creates an array of unique values that is the [symmetric difference](https://en.wikipedia.org/wiki/Symmetric_difference)
   * of the provided arrays.
   *
   * @static
   * @memberOf _
   * @category Array
   * @param {...Array} [arrays] The arrays to inspect.
   * @returns {Array} Returns the new array of values.
   * @example
   *
   * _.xor([2, 1], [4, 2]);
   * // => [1, 4]
   */
  var xor = rest(function(arrays) {
    return baseXor(arrayFilter(arrays, isArrayLikeObject));
  });

  return xor;
});
