import React from 'react';
import {
  Step,
  Stepper,
  StepLabel,
} from 'material-ui/Stepper';
import WarningIcon from 'material-ui/svg-icons/alert/warning';
import {red500} from 'material-ui/styles/colors';

/**
 * Custom icons can be used to create different visual states.
 */
class CustomIcon extends React.Component {

  state = {
    stepIndex: 0,
  };

  handleNext = () => {
    const {stepIndex} = this.state;
    if (stepIndex < 2) {
      this.setState({stepIndex: stepIndex + 1});
    }
  };

  handlePrev = () => {
    const {stepIndex} = this.state;
    if (stepIndex > 0) {
      this.setState({stepIndex: stepIndex - 1});
    }
  };

  getStepContent(stepIndex) {
    switch (stepIndex) {
      case 0:
        return 'Select campaign settings...';
      case 1:
        return 'What is an ad group anyways?';
      case 2:
        return 'This is the bit I really care about!';
      default:
        return 'You\'re a long way from home sonny jim!';
    }
  }

  render() {
    return (
      <div style={{width: '100%', maxWidth: 700, margin: 'auto'}}>
        <Stepper linear={false}>
          <Step completed={false}>
            <StepLabel>
              Select campaign settings
            </StepLabel>
          </Step>
          <Step completed={false}>
            <StepLabel
              icon={<WarningIcon color={red500} />}
              style={{color: red500}}
            >
              Create an ad group
            </StepLabel>
          </Step>
          <Step completed={false}>
            <StepLabel>
              Create an ad
            </StepLabel>
          </Step>
        </Stepper>
      </div>
    );
  }
}

export default CustomIcon;
