# Function bignumber

Create a BigNumber, which can store numbers with arbitrary precision.
When a matrix is provided, all elements will be converted to BigNumber.


## Syntax

```js
math.bignumber(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`value` | Number &#124; String &#124; Array &#124; Matrix &#124; Boolean &#124; null | Value for the big number, 0 by default.

### Returns

Type | Description
---- | -----------
BigNumber | The created bignumber


## Examples

```js
0.1 + 0.2;                                  // returns Number 0.30000000000000004
math.bignumber(0.1) + math.bignumber(0.2);  // returns BigNumber 0.3


7.2e500;                                    // returns Number Infinity
math.bignumber('7.2e500');                  // returns BigNumber 7.2e500
```


## See also

[boolean](boolean.md),
[complex](complex.md),
[index](index.md),
[matrix](matrix.md),
[string](string.md),
[unit](unit.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
