# Function bitXor

Bitwise XOR two values, `x ^ y`.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.bitXor(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | First value to xor
`y` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | Second value to xor

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Array &#124; Matrix | XOR of `x` and `y`


## Examples

```js
math.bitXor(1, 2);               // returns Number 3

math.bitXor([2, 3, 4], 4);       // returns Array [6, 7, 0]
```


## See also

[bitAnd](bitAnd.md),
[bitNot](bitNot.md),
[bitOr](bitOr.md),
[leftShift](leftShift.md),
[rightArithShift](rightArithShift.md),
[rightLogShift](rightLogShift.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
