# Function dotMultiply

Multiply two matrices element wise. The function accepts both matrices and
scalar values.


## Syntax

```js
math.dotMultiply(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | Left hand value
`y` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | Right hand value

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Multiplication of `x` and `y`


## Examples

```js
math.dotMultiply(2, 4); // returns 8

a = [[9, 5], [6, 1]];
b = [[3, 2], [5, 2]];

math.dotMultiply(a, b); // returns [[27, 10], [30, 2]]
math.multiply(a, b);    // returns [[52, 28], [23, 14]]
```


## See also

[multiply](multiply.md),
[divide](divide.md),
[dotDivide](dotDivide.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
