# Function dotPow

Calculates the power of x to y element wise.


## Syntax

```js
math.dotPow(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | The base
`y` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | The exponent

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Complex &#124; Unit &#124; Array &#124; Matrix | The value of `x` to the power `y`


## Examples

```js
math.dotPow(2, 3);            // returns Number 8

var a = [[1, 2], [4, 3]];
math.dotPow(a, 2);            // returns Array [[1, 4], [16, 9]]
math.pow(a, 2);               // returns Array [[9, 8], [16, 17]]
```


## See also

[pow](pow.md),
[sqrt](sqrt.md),
[multiply](multiply.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
