# Function exp

Calculate the exponent of a value.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.exp(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Array &#124; Matrix &#124; null | A number or matrix to exponentiate

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Complex &#124; Array &#124; Matrix | Exponent of `x`


## Examples

```js
math.exp(2);                  // returns Number 7.3890560989306495
math.pow(math.e, 2);          // returns Number 7.3890560989306495
math.log(math.exp(2));        // returns Number 2

math.exp([1, 2, 3]);
// returns Array [
//   2.718281828459045,
//   7.3890560989306495,
//   20.085536923187668
// ]
```


## See also

[log](log.md),
[pow](pow.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
