# Function smallerEq

Test whether value x is smaller or equal to y.

The function returns true when x is smaller than y or the relative
difference between x and y is smaller than the configured epsilon. The
function cannot be used to compare values smaller than approximately 2.22e-16.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.smallerEq(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Unit &#124; String &#124; Array &#124; Matrix &#124; null | First value to compare
`y` | Number &#124; BigNumber &#124; Boolean &#124; Unit &#124; String &#124; Array &#124; Matrix &#124; null | Second value to compare

### Returns

Type | Description
---- | -----------
Boolean &#124; Array &#124; Matrix | Returns true when the x is smaller than y, else returns false


## Examples

```js
math.smaller(1 + 2, 3);        // returns false
math.smallerEq(1 + 2, 3);      // returns true
```


## See also

[equal](equal.md),
[unequal](unequal.md),
[smaller](smaller.md),
[larger](larger.md),
[largerEq](largerEq.md),
[compare](compare.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
