# Function and

Logical `and`. Test whether two values are both defined with a nonzero/nonempty value.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.and(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | First value to check
`y` | Number &#124; BigNumber &#124; Boolean &#124; Complex &#124; Unit &#124; Array &#124; Matrix &#124; null | Second value to check

### Returns

Type | Description
---- | -----------
Boolean &#124; Array &#124; Matrix |  Returns true when both inputs are defined with a nonzero/nonempty value.


## Examples

```js
math.and(2, 4);   // returns true

a = [2, 0, 0];
b = [3, 7, 0];
c = 0;

math.and(a, b);   // returns [true, false, false]
math.and(a, c);   // returns [false, false, false]
```


## See also

[not](not.md),
[or](or.md),
[xor](xor.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
