# Function bitNot

Bitwise NOT value, `~x`.
For matrices, the function is evaluated element wise.
For units, the function is evaluated on the best prefix base.


## Syntax

```js
math.bitNot(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | Value to not

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Array &#124; Matrix | NOT of `x`


## Examples

```js
math.bitNot(1);               // returns Number -2

math.bitNot([2, -3, 4]);      // returns Array [-3, 2, 5]
```


## See also

[bitAnd](bitAnd.md),
[bitOr](bitOr.md),
[bitXor](bitXor.md),
[leftShift](leftShift.md),
[rightArithShift](rightArithShift.md),
[rightLogShift](rightLogShift.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
