# Function concat

Concatenate two or more matrices.


## Syntax

```js
math.concat(A, B, C, ...)
math.concat(A, B, C, ..., dim)
```

### Where

- `dim: number` is a zero-based dimension over which to concatenate the matrices.
  By default the last dimension of the matrices.

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`args` | ... Array &#124; Matrix | Two or more matrices

### Returns

Type | Description
---- | -----------
Array &#124; Matrix | Concatenated matrix


## Examples

```js
var A = [[1, 2], [5, 6]];
var B = [[3, 4], [7, 8]];

math.concat(A, B);      // returns [[1, 2, 3, 4], [5, 6, 7, 8]]
math.concat(A, B, 0);   // returns [[1, 2], [5, 6], [3, 4], [7, 8]]
```


## See also

[size](size.md),
[squeeze](squeeze.md),
[subset](subset.md),
[transpose](transpose.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
