# Function eval

Evaluate an expression.


## Syntax

```js
math.eval(expr)
math.eval(expr, scope)
math.eval([expr1, expr2, expr3, ...])
math.eval([expr1, expr2, expr3, ...], scope)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`expr` | String &#124; String[] &#124; Matrix | The expression to be evaluated
`scope` | Object | Scope to read/write variables

### Returns

Type | Description
---- | -----------
* | The result of the expression


## Examples

```js
math.eval('(2+3)/4');                // 1.25
math.eval('sqrt(3^2 + 4^2)');        // 5
math.eval('sqrt(-4)');               // 2i
math.eval(['a=3', 'b=4', 'a*b']);,   // [3, 4, 12]

var scope = {a:3, b:4};
math.eval('a * b', scope);           // 12
```


## See also

[parse](parse.md),
[compile](compile.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
