# Function filter

Sort the items in a matrix.


## Syntax

```js
math.filter(x, test)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Matrix &#124; Array | A one dimensional matrix or array to filter
`test` | Function &#124; RegExp |  A function or regular expression to test items. When `test` is a function, it must return a boolean. All entries for which `test` returns true are returned.

### Returns

Type | Description
---- | -----------
Matrix &#124; Array | Returns the filtered matrix.


## Examples

```js
function isPositive (x) {
  return x > 0;
}
math.filter([6, -2, -1, 4, 3], isPositive); // returns [6, 4, 3]

math.filter(["23", "foo", "100", "55", "bar"], /[0-9]+/); // returns ["23", "100", "55"]
```


## See also

[forEach](forEach.md),
[map](map.md),
[sort](sort.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
