# Function mod

Calculates the modulus, the remainder of an integer division.

For matrices, the function is evaluated element wise.

The modulus is defined as:

    x - y * floor(x / y)

See http://en.wikipedia.org/wiki/Modulo_operation.


## Syntax

```js
math.mod(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | Dividend
`y` | Number &#124; BigNumber &#124; Boolean &#124; Array &#124; Matrix &#124; null | Divisor

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber &#124; Array &#124; Matrix | Returns the remainder of `x` divided by `y`.


## Examples

```js
math.mod(8, 3);                // returns 2
math.mod(11, 2);               // returns 1

function isOdd(x) {
  return math.mod(x, 2) != 0;
}

isOdd(2);                      // returns false
isOdd(3);                      // returns true
```


## See also

[divide](divide.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
