# Function permutations

Compute the number of ways of obtaining an ordered subset of `k` elements
from a set of `n` elements.

Permutations only takes integer arguments.
The following condition must be enforced: k <= n.


## Syntax

```js
math.permutations(n)
math.permutations(n, k)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`n` | Number &#124; BigNumber | The number of objects in total
`k` | Number &#124; BigNumber | The number of objects in the subset

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber | The number of permutations


## Examples

```js
math.permutations(5);     // 120
math.permutations(5, 3);  // 60
```


## See also

[combinations](combinations.md),
[factorial](factorial.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
