# Function random

Return a random number larger or equal to `min` and smaller than `max`
using a uniform distribution.


## Syntax

```js
math.random()                // generate a random number between 0 and 1
math.random(max)             // generate a random number between 0 and max
math.random(min, max)        // generate a random number between min and max
math.random(size)            // generate a matrix with random numbers between 0 and 1
math.random(size, max)       // generate a matrix with random numbers between 0 and max
math.random(size, min, max)  // generate a matrix with random numbers between min and max
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`size` | Array &#124; Matrix | If provided, an array or matrix with given size and filled with random values is returned
`min` | Number | Minimum boundary for the random value, included
`max` | Number | Maximum boundary for the random value, excluded

### Returns

Type | Description
---- | -----------
Number &#124; Array &#124; Matrix | A random number


## Examples

```js
math.random();       // returns a random number between 0 and 1
math.random(100);    // returns a random number between 0 and 100
math.random(30, 40); // returns a random number between 30 and 40
math.random([2, 3]); // returns a 2x3 matrix with random numbers between 0 and 1
```


## See also

[randomInt](randomInt.md),
[pickRandom](pickRandom.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
