# Function typeof

Determine the type of a variable.

Function `typeof` recognizes the following types of objects:

Object                 | Returns       | Example
---------------------- | ------------- | ------------------------------------------
Array                  | `'array'`     | `math.typeof ([1, 2, 3])`
boolean                | `'boolean'`   | `math.typeof (true)`
Date                   | `'date'`      | `math.typeof (new Date())`
null                   | `'null'`      | `math.typeof(null)`
number                 | `'number'`    | `math.typeof(3.5)`
Object                 | `'object'`    | `math.typeof ({a: 2, b: 3})`
RegExp                 | `'regexp'`    | `math.typeof (/a regexp/)`
string                 | `'string'`    | `math.typeof ('hello world')`
undefined              | `'undefined'` | `math.typeof(undefined)`
math.chaining.Chain    | `'chain'`     | `math.typeof (math.chain(2))`
math.type.BigNumber    | `'bignumber'` | `math.typeof (math.bignumber('2.3e500'))`
math.type.Complex      | `'complex'`   | `math.typeof (math.complex(2, 3))`
math.type.Help         | `'help'`      | `math.typeof (math.help('sqrt'))`
math.type.Index        | `'index'`     | `math.typeof (math.index(1, 3))`
math.type.Matrix       | `'matrix'`    | `math.typeof (math.matrix([[1,2], [3, 4]]))`
math.type.Range        | `'range'`     | `math.typeof (math.range(0, 10))`
math.type.Unit         | `'unit'`      | `math.typeof (math.unit('45 deg'))`


## Syntax

```js
math.typeof(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | * | The variable for which to test the type.

### Returns

Type | Description
---- | -----------
String | Lower case type, for example 'number', 'string', 'array'.


## Examples

```js
math.typeof(3.5);                     // returns 'number'
math.typeof(math.complex('2 - 4i'));  // returns 'complex'
math.typeof(math.unit('45 deg'));     // returns 'unit'
math.typeof('hello world');           // returns 'string'
```




<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
