# Function add

Add two values, `x + y`.
For matrices, the function is evaluated element wise.


## Syntax

```js
math.add(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Unit &#124; Array &#124; Matrix | First value to add
`y` | number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Second value to add

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Fraction &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Sum of `x` and `y`


## Examples

```js
math.add(2, 3);               // returns number 5

var a = math.complex(2, 3);
var b = math.complex(-4, 1);
math.add(a, b);               // returns Complex -2 + 4i

math.add([1, 2, 3], 4);       // returns Array [5, 6, 7]

var c = math.unit('5 cm');
var d = math.unit('2.1 mm');
math.add(c, d);               // returns Unit 52.1 mm

math.add("2.3", "4");         // returns number 6.3
```


## See also

[subtract](subtract.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
