# Function eye

Create a 2-dimensional identity matrix with size m x n or n x n.
The matrix has ones on the diagonal and zeros elsewhere.


## Syntax

```js
math.eye(n)
math.eye(n, format)
math.eye(m, n)
math.eye(m, n, format)
math.eye([m, n])
math.eye([m, n], format)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`size` | ...number &#124; Matrix &#124; Array | The size for the matrix
`format` | string | The Matrix storage format

### Returns

Type | Description
---- | -----------
Matrix &#124; Array &#124; number | A matrix with ones on the diagonal.


## Examples

```js
math.eye(3);                    // returns [[1, 0, 0], [0, 1, 0], [0, 0, 1]]
math.eye(3, 2);                 // returns [[1, 0], [0, 1], [0, 0]]

var A = [[1, 2, 3], [4, 5, 6]];
math.eye(math.size(b));         // returns [[1, 0, 0], [0, 1, 0]]
```


## See also

[diag](diag.md),
[ones](ones.md),
[zeros](zeros.md),
[size](size.md),
[range](range.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
