# Function leftShift

Bitwise left logical shift of a value x by y number of bits, `x << y`.
For matrices, the function is evaluated element wise.
For units, the function is evaluated on the best prefix base.


## Syntax

```js
math.leftShift(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Array &#124; Matrix | Value to be shifted
`y` | number &#124; BigNumber | Amount of shifts

### Returns

Type | Description
---- | -----------
number &#124; BigNumber &#124; Array &#124; Matrix | `x` shifted left `y` times


## Examples

```js
math.leftShift(1, 2);               // returns number 4

math.leftShift([1, 2, 3], 4);       // returns Array [16, 32, 64]
```


## See also

[leftShift](leftShift.md),
[bitNot](bitNot.md),
[bitOr](bitOr.md),
[bitXor](bitXor.md),
[rightArithShift](rightArithShift.md),
[rightLogShift](rightLogShift.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
