# Function lsolve

Solves the linear equation system by forwards substitution. Matrix must be a lower triangular matrix.

`L * x = b`


## Syntax

```js
math.lsolve(L, b);
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`L` | Matrix, Array | A N x N matrix or array (L)
`b` | Matrix, Array | A column vector with the b values

### Returns

Type | Description
---- | -----------
DenseMatrix &#124; Array | A column vector with the linear system solution (x)


## Examples

```js
var a = [[-2, 3], [2, 1]];
var b = [11, 9];
var x = lsolve(a, b);  // [[-5.5], [20]]
```


## See also

[lup](lup.md),
[slu](slu.md),
[usolve](usolve.md),
[lusolve](lusolve.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
