# Function stirlingS2

The Stirling numbers of the second kind, counts the number of ways to partition
a set of n labelled objects into k nonempty unlabelled subsets.
stirlingS2 only takes integer arguments.
The following condition must be enforced: k <= n.

 If n = k or k = 1, then s(n,k) = 1


## Syntax

```js
math.stirlingS2(n, k)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`n` | Number &#124; BigNumber | Total number of objects in the set
`k` | Number &#124; BigNumber | Number of objects in the subset

### Returns

Type | Description
---- | -----------
Number &#124; BigNumber | S(n,k)


## Examples

```js
math.stirlingS2(5, 3); //returns 25
```


## See also

[Bell numbers](Bell numbers.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
