# Function usolve

Solves the linear equation system by backward substitution. Matrix must be an upper triangular matrix.

`U * x = b`


## Syntax

```js
math.usolve(U, b);
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`U` | Matrix, Array | A N x N matrix or array (U)
`b` | Matrix, Array | A column vector with the b values

### Returns

Type | Description
---- | -----------
DenseMatrix &#124; Array | A column vector with the linear system solution (x)


## Examples

```js
var a = [[-2, 3], [2, 1]];
var b = [11, 9];
var x = usolve(a, b);  // [[8], [9]]
```


## See also

[lup](lup.md),
[slu](slu.md),
[usolve](usolve.md),
[lusolve](lusolve.md)


<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->
