<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function coth

Calculate the hyperbolic cotangent of a value,
defined as `coth(x) = 1 / tanh(x)`.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.coth(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; Complex &#124; Unit &#124; Array &#124; Matrix | Function input

### Returns

Type | Description
---- | -----------
number &#124; Complex &#124; Array &#124; Matrix | Hyperbolic cotangent of x


## Examples

```js
// coth(x) = 1 / tanh(x)
math.coth(2);         // returns 1.0373147207275482
1 / math.tanh(2);     // returns 1.0373147207275482
```


## See also

[sinh](sinh.md),
[tanh](tanh.md),
[cosh](cosh.md)
