<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function index

Create an index. An Index can store ranges having start, step, and end
for multiple dimensions.
Matrix.get, Matrix.set, and math.subset accept an Index as input.


## Syntax

```js
math.index(range1, range2, ...)
```

### Where

- A number
- A string for getting/setting an object property
- An instance of `Range`
- A one-dimensional Array or a Matrix with numbers

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`ranges` | ...* | Zero or more ranges or numbers.

### Returns

Type | Description
---- | -----------
Index | Returns the created index


## Examples

```js
var math = math.js

var b = [1, 2, 3, 4, 5];
math.subset(b, math.index([1, 2, 3]));     // returns [2, 3, 4]

var a = math.matrix([[1, 2], [3, 4]]);
a.subset(math.index(0, 1));             // returns 2
```


## See also

[bignumber](bignumber.md),
[boolean](boolean.md),
[complex](complex.md),
[matrix](matrix.md),
[number](number.md),
[string](string.md),
[unit](unit.md)
