<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function isInteger

Test whether a value is an integer number.
The function supports `number`, `BigNumber`, and `Fraction`.

The function is evaluated element-wise in case of Array or Matrix input.


## Syntax

```js
math.isInteger(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; Array &#124; Matrix | Value to be tested

### Returns

Type | Description
---- | -----------
boolean | Returns true when `x` contains a numeric, integer value. Throws an error in case of an unknown data type.


## Examples

```js
math.isInteger(2);                     // returns true
math.isInteger(0);                     // returns true
math.isInteger(0.5);                   // returns false
math.isInteger(math.bignumber(500));   // returns true
math.isInteger(math.fraction(4));      // returns true
math.isInteger('3');                   // returns true
math.isInteger([3, 0.5, -2]);          // returns [true, false, true]
math.isInteger(math.complex('2-4i');   // throws an error
```


## See also

[isNumeric](isNumeric.md),
[isPositive](isPositive.md),
[isNegative](isNegative.md),
[isZero](isZero.md)
