<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function pickRandom

Random pick one or more values from a one dimensional array.
Array elements are picked using a random function with uniform or weighted distribution.


## Syntax

```js
math.pickRandom(array)
math.pickRandom(array, number)
math.pickRandom(array, weights)
math.pickRandom(array, number, weights)
math.pickRandom(array, weights, number)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`array` | Array | A one dimensional array
`number` | Int | An int or float
`weights` | Array | An array of ints or floats

### Returns

Type | Description
---- | -----------
array | An array of elements of the provided input array


## Examples

```js
math.pickRandom([3, 6, 12, 2]);                  // returns one of the values in the array
math.pickRandom([3, 6, 12, 2], 2);               // returns an array of two of the values in the array
math.pickRandom([3, 6, 12, 2], [1, 3, 2, 1]);    // returns one of the values in the array with weighted distribution
math.pickRandom([3, 6, 12, 2], 2, [1, 3, 2, 1]); // returns an array of two of the values in the array with weighted distribution
math.pickRandom([3, 6, 12, 2], [1, 3, 2, 1], 2); // returns an array of two of the values in the array with weighted distribution
```


## See also

[random](random.md),
[randomInt](randomInt.md)
