<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function sort

Sort the items in a matrix.


## Syntax

```js
math.sort(x)
math.sort(x, compare)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Matrix &#124; Array | A one dimensional matrix or array to sort
`compare` | Function &#124; 'asc' &#124; 'desc' |  An optional _comparator function. The function is called as `compare(a, b)`, and must return 1 when a > b, -1 when a < b, and 0 when a == b. Default value: 'asc'.

### Returns

Type | Description
---- | -----------
Matrix &#124; Array | Returns the sorted matrix.


## Examples

```js
math.sort([5, 10, 1]); // returns [1, 5, 10]
math.sort(['C', 'B', 'A', 'D']); // returns ['A', 'B', 'C', 'D']

function sortByLength (a, b) {
  return a.length - b.length;
}
math.sort(['Langdon', 'Tom', 'Sara'], sortByLength); // returns ['Tom', 'Sara', 'Langdon']
```


## See also

[filter](filter.md),
[forEach](forEach.md),
[map](map.md)
