# Documentation

[Math.js](http://mathjs.org) is an extensive math library for JavaScript and Node.js.
It features a flexible expression parser, a large set of built-in functions and constants,
and offers an integrated solution to work with different data types like numbers,
big numbers, complex numbers, units, and matrices.

Math.js can be used in the browser, in node.js and in any JavaScript engine. Installation and download instructions are available on the [Download page](http://mathjs.org/download.html) of the website.

## Getting Started

- [Getting Started](getting_started.md)
- [Examples](http://mathjs.org/examples/index.html)

## Documentation

- **[Core](core/index.md)**
  - [Configuration](core/configuration.md)
  - [Chaining](core/chaining.md)
  - [Extension](core/extension.md)
  - [Serialization](core/serialization.md)
- **[Expressions](expressions/index.md)**
  - [Parsing and evaluation](expressions/parsing.md)
  - [Syntax](expressions/syntax.md)
  - [Expression trees](expressions/expression_trees.md)
  - [Customization](expressions/customization.md)
- **[Data Types](datatypes/index.md)**
  - [Numbers](datatypes/numbers.md)
  - [BigNumbers](datatypes/bignumbers.md)
  - [Fractions](datatypes/fractions.md)
  - [Complex Numbers](datatypes/complex_numbers.md)
  - [Matrices](datatypes/matrices.md)
  - [Units](datatypes/units.md)
- **[Reference](reference/index.md)**
  - [Classes](reference/classes.md)
  - [Functions](reference/functions.md)
  - [Constants](reference/constants.md)
- [Custom bundling](custom_bundling.md)
- [Command Line Interface](command_line_interface.md)
- [History](../HISTORY.md)
