<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function smaller

Test whether value x is smaller than y.

The function returns true when x is smaller than y and the relative
difference between x and y is smaller than the configured epsilon. The
function cannot be used to compare values smaller than approximately 2.22e-16.

For matrices, the function is evaluated element wise.


## Syntax

```js
math.smaller(x, y)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | number &#124; BigNumber &#124; Fraction &#124; boolean &#124; Unit &#124; string &#124; Array &#124; Matrix | First value to compare
`y` | number &#124; BigNumber &#124; Fraction &#124; boolean &#124; Unit &#124; string &#124; Array &#124; Matrix | Second value to compare

### Returns

Type | Description
---- | -----------
boolean &#124; Array &#124; Matrix | Returns true when the x is smaller than y, else returns false


## Examples

```js
math.smaller(2, 3);            // returns true
math.smaller(5, 2 * 2);        // returns false

var a = math.unit('5 cm');
var b = math.unit('2 inch');
math.smaller(a, b);            // returns true
```


## See also

[equal](equal.md),
[unequal](unequal.md),
[smallerEq](smallerEq.md),
[smaller](smaller.md),
[smallerEq](smallerEq.md),
[compare](compare.md)
