<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function sparse

Create a Sparse Matrix. The function creates a new `math.type.Matrix` object from
an `Array`. A Matrix has utility functions to manipulate the data in the
matrix, like getting the size and getting or setting values in the matrix.


## Syntax

```js
math.sparse()               // creates an empty sparse matrix.
math.sparse(data)           // creates a sparse matrix with initial data.
math.sparse(data, 'number') // creates a sparse matrix with initial data, number datatype.
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`data` | Array &#124; Matrix | A two dimensional array

### Returns

Type | Description
---- | -----------
Matrix | The created matrix


## Examples

```js
var m = math.sparse([[1, 2], [3, 4]]);
m.size();                        // Array [2, 2]
m.resize([3, 2], 5);
m.valueOf();                     // Array [[1, 2], [3, 4], [5, 5]]
m.get([1, 0])                    // number 3
```


## See also

[bignumber](bignumber.md),
[boolean](boolean.md),
[complex](complex.md),
[index](index.md),
[number](number.md),
[string](string.md),
[unit](unit.md),
[matrix](matrix.md)
