## Contributing

Contributions to the math.js library are very welcome! We can't do this alone.
You can contribute in different ways: spread the word, report bugs, come up with
ideas and suggestions, and contribute to the code.

There are a few preferences regarding code contributions:

- The code of math.js follows the JavaScript Standard Style as described on https://standardjs.com/.
- Make sure you properly unit test your changes.
- Before creating a pull request, run the unit tests to make sure they all pass.
- Only commit changes done in the source files under `src`, not to the generated builds
  which are located in the folders `dist` and `lib`.
- Send pull requests to the `develop` branch, not the `master` branch.

What can I do?

- Search through the [issues](https://github.com/josdejong/mathjs/issues) looking
  for something that looks interesting to you to pick up. Some issues are marked
  ["help wanted"](https://github.com/josdejong/mathjs/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22),
  these are typically issues which should be relatively easy to pick up.

Thanks!
