'use strict'

define ['angular'], (angular) ->
  angular.module 'ngModules.directives.changeTagsTo', []
  .constant 'changeTagsToConfig',
    seperator: '|'
  .directive 'changeTagsTo', [
    'changeTagsToConfig', '$parse', 'uniqueFilter'
    (changeTagsToConfig, $parse, uniqueFilter) ->
      restrict: 'AC'
      require: 'tagsInput'
      link: (scope, element, attrs) ->
        getModel = $parse(attrs.ngModel)
        setModel = getModel.assign
        getTo = $parse(attrs.changeTagsTo)
        setTo = getTo.assign

        seperator = changeTagsToConfig.seperator
        attrs.$observe 'changeTagsToSeperator', (value) ->
          seperator = value or changeTagsToConfig.seperator

        scope.$watch getTo, (value) ->
          tags = uniqueFilter(value?.split?(seperator)?.filter?((a) -> !!a)) or []
          setModel(scope, text: tag  for tag in tags)

        scope.$watchCollection(->
          tag.text  for tag in getModel(scope) or []
        , (tags) -> if tags? and setTo?
          setTo(scope, (tag  for tag in tags or []).join(seperator))
        )

        return #nothing
  ]
