(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.directives.changeTagsTo', []).constant('changeTagsToConfig', {
      seperator: '|'
    }).directive('changeTagsTo', [
      'changeTagsToConfig', '$parse', 'uniqueFilter', function(changeTagsToConfig, $parse, uniqueFilter) {
        return {
          restrict: 'AC',
          require: 'tagsInput',
          link: function(scope, element, attrs) {
            var getModel, getTo, seperator, setModel, setTo;
            getModel = $parse(attrs.ngModel);
            setModel = getModel.assign;
            getTo = $parse(attrs.changeTagsTo);
            setTo = getTo.assign;
            seperator = changeTagsToConfig.seperator;
            attrs.$observe('changeTagsToSeperator', function(value) {
              return seperator = value || changeTagsToConfig.seperator;
            });
            scope.$watch(getTo, function(value) {
              var tag, tags, _ref;
              tags = uniqueFilter(value != null ? typeof value.split === "function" ? (_ref = value.split(seperator)) != null ? typeof _ref.filter === "function" ? _ref.filter(function(a) {
                return !!a;
              }) : void 0 : void 0 : void 0 : void 0) || [];
              return setModel(scope, (function() {
                var _i, _len, _results;
                _results = [];
                for (_i = 0, _len = tags.length; _i < _len; _i++) {
                  tag = tags[_i];
                  _results.push({
                    text: tag
                  });
                }
                return _results;
              })());
            });
            scope.$watchCollection(function() {
              var tag, _i, _len, _ref, _results;
              _ref = getModel(scope) || [];
              _results = [];
              for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                tag = _ref[_i];
                _results.push(tag.text);
              }
              return _results;
            }, function(tags) {
              var tag;
              if ((tags != null) && (setTo != null)) {
                return setTo(scope, ((function() {
                  var _i, _len, _ref, _results;
                  _ref = tags || [];
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    tag = _ref[_i];
                    _results.push(tag);
                  }
                  return _results;
                })()).join(seperator));
              }
            });
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=changeTagsTo.js.map
