(function() {
  'use strict';
  define(['jquery-extends', 'angular'], function($, angular) {
    return angular.module('ngModules.directives.changeTagsToArray', []).directive('changeTagsToArray', [
      '$parse', 'uniqueFilter', function($parse, uniqueFilter) {
        return {
          restrict: 'AC',
          require: 'tagsInput',
          link: function(scope, element, attrs) {
            var getModel, getTo, setModel, setTo;
            getModel = $parse(attrs.ngModel);
            setModel = getModel.assign;
            getTo = $parse(attrs.changeTagsToArray);
            setTo = getTo.assign;
            scope.$watch(getTo, function(value) {
              var tag;
              return setModel(scope, (function() {
                var _i, _len, _ref, _results;
                _ref = uniqueFilter($.makeArray(value));
                _results = [];
                for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                  tag = _ref[_i];
                  _results.push({
                    text: tag
                  });
                }
                return _results;
              })());
            });
            scope.$watchCollection(function() {
              var tag, _i, _len, _ref, _results;
              _ref = getModel(scope) || [];
              _results = [];
              for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                tag = _ref[_i];
                _results.push(tag.text);
              }
              return _results;
            }, function(tags) {
              var tag;
              if ((tags != null) && (setTo != null)) {
                return setTo(scope, (function() {
                  var _i, _len, _ref, _results;
                  _ref = tags || [];
                  _results = [];
                  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                    tag = _ref[_i];
                    _results.push(tag);
                  }
                  return _results;
                })());
              }
            });
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=changeTagsToArray.js.map
