(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.directives.countTo', []).directive('countTo', [
      '$timeout', function($timeout) {
        return {
          replace: false,
          scope: true,
          link: function(scope, element, attrs) {
            var calculate, countTo, elem, increment, num, refreshInterval, start, step, steps, tick;
            elem = element[0];
            num = null;
            refreshInterval = null;
            steps = null;
            step = null;
            countTo = null;
            increment = null;
            calculate = function() {
              var duration;
              refreshInterval = 30;
              step = 0;
              scope.timoutId = null;
              countTo = parseInt(attrs.countTo) || 0;
              scope.value = parseInt(attrs.value, 10) || 0;
              duration = (parseFloat(attrs.duration) * 1000) || 0;
              steps = Math.ceil(duration / refreshInterval);
              increment = (countTo - scope.value) / steps;
              return num = scope.value;
            };
            tick = function() {
              return scope.timoutId = $timeout(function() {
                num += increment;
                step++;
                if (step >= steps) {
                  $timeout.cancel(scope.timoutId);
                  num = countTo;
                  return elem.textContent = countTo;
                } else {
                  elem.textContent = Math.round(num);
                  return tick();
                }
              }, refreshInterval);
            };
            start = function() {
              if (scope.timoutId != null) {
                $timeout.cancel(scope.timoutId);
              }
              calculate();
              return tick();
            };
            attrs.$observe('countTo', function(val) {
              if (val != null) {
                return start();
              }
            });
            attrs.$observe('value', function() {
              return start();
            });
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=countTo.js.map
