(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.directives.dateParser', []).constant('dateParserConfig', {
      'dateFormat': 'yyyy-MM-dd'
    }).directive('dateParser', [
      'dateParserConfig', 'dateFilter', 'dateParserFilter', function(dateParserConfig, dateFilter, dateParserFilter) {
        return {
          restrict: 'A',
          require: 'ngModel',
          link: function(scope, elem, attrs, ngModel) {
            var dateFormat;
            dateFormat = null;
            attrs.$observe('dateParser', function(value) {
              dateFormat = value || dateParserConfig.dateFormat;
              return ngModel.$render();
            });
            ngModel.$parsers.unshift(function(value) {
              var date;
              date = dateParserFilter(value, dateFormat);
              ngModel.$setValidity('date', !value || angular.isDate(date));
              return date;
            });
            ngModel.$render = function() {
              elem.val(ngModel.$modelValue ? dateFilter(ngModel.$modelValue, dateFormat) : void 0);
              return scope.ngModel = ngModel.$modelValue;
            };
            ngModel.$formatters.push(function(modelValue) {
              ngModel.$setValidity('date', !modelValue || angular.isDate(modelValue));
              if (angular.isDate(modelValue)) {
                return dateFilter(modelValue, dateFormat);
              } else {
                return '';
              }
            });
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=dateParser.js.map
