(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.directives.lower', []).directive('lower', [
      function() {
        return {
          require: 'ngModel',
          link: function(scope, element, attrs, modelCtrl) {
            var toLower;
            toLower = function(inputValue) {
              var lowered;
              lowered = inputValue ? inputValue.toLowerCase() : inputValue;
              if (lowered !== inputValue) {
                modelCtrl.$setViewValue(lowered);
                modelCtrl.$render();
              }
              return lowered;
            };
            modelCtrl.$parsers.push(toLower);
            toLower(scope[attrs.ngModel]);
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=lower.js.map
