'use strict'

define ['angular'], (angular) ->
  angular.module 'ngModules.directives.rotate2d', []
  .directive 'rotate2d', [->
    scope:
      value: '=rotate2d'
      limit: '='
      angle: '='
    link: (scope, element) ->
      scope.$watchCollection '[value, limit, angle]', (values) ->
        value = values[0] or 0
        limit = values[1] or 10
        angle = values[2] or 360
        degree = value * angle / limit
        console.log "change rotate2d", element, degree
        element.css
          '-webkit-transform': 'rotate(' + degree + 'deg)'
          '-moz-transform': 'rotate(' + degree + 'deg)'
          'transform': 'rotate(' + degree + 'deg)'
        return #nothing
      return #nothing
  ]
