(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.directives.rotate2d', []).directive('rotate2d', [
      function() {
        return {
          scope: {
            value: '=rotate2d',
            limit: '=',
            angle: '='
          },
          link: function(scope, element) {
            scope.$watchCollection('[value, limit, angle]', function(values) {
              var angle, degree, limit, value;
              value = values[0] || 0;
              limit = values[1] || 10;
              angle = values[2] || 360;
              degree = value * angle / limit;
              console.log("change rotate2d", element, degree);
              element.css({
                '-webkit-transform': 'rotate(' + degree + 'deg)',
                '-moz-transform': 'rotate(' + degree + 'deg)',
                'transform': 'rotate(' + degree + 'deg)'
              });
            });
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=rotate2d.js.map
