(function() {
  'use strict';
  define(['angular'], function(angular) {
    return angular.module('ngModules.directives.splitTagsWhenPaste', []).constant('splitTagsWhenPasteConfig', {
      delimiter: /[|/\n]/g
    }).directive('splitTagsWhenPaste', [
      'splitTagsWhenPasteConfig', '$parse', function(splitTagsWhenPasteConfig, $parse) {
        return {
          restrict: 'AC',
          require: 'tagsInput',
          link: function(scope, element, attrs) {
            var delimiter, getModel, setModel;
            delimiter = null;
            attrs.$observe('splitTagsWhenPaste', function(value) {
              delimiter = value || splitTagsWhenPasteConfig.delimiter;
              if (!(delimiter instanceof RegExp)) {
                return delimiter = new RegExp(delimiter.toString(), 'g');
              }
            });
            getModel = $parse(attrs.ngModel);
            setModel = getModel.assign;
            element.on('paste', function(e) {
              var splitedValue, tags, text, _i, _len, _ref;
              e.preventDefault();
              e.stopPropagation();
              splitedValue = (_ref = e.originalEvent.clipboardData.getData('text/plain')) != null ? typeof _ref.split === "function" ? _ref.split(delimiter).filter(function(a) {
                return !!a;
              }) : void 0 : void 0;
              if (splitedValue.length > 0) {
                tags = getModel(scope) || [];
                for (_i = 0, _len = splitedValue.length; _i < _len; _i++) {
                  text = splitedValue[_i];
                  if (!tags.some(function(a) {
                    return a.text === text;
                  })) {
                    tags.push({
                      text: text
                    });
                  }
                }
                return scope.$evalAsync(function() {
                  return setModel(scope, tags);
                });
              }
            });
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=splitTagsWhenPaste.js.map
