(function() {
  'use strict';
  var __slice = [].slice;

  define(['angular', 'jquery-extends'], function(angular, $) {
    return angular.module('ngModules.filters.arrays', []).filter('makeArray', [
      function() {
        return function(input) {
          if (angular.isArray(input)) {
            return input;
          } else {
            return $.makeArray(input);
          }
        };
      }
    ]).filter('range', [
      function() {
        return Array.range;
      }
    ]).filter('join', [
      function() {
        return function(input, sep) {
          return $.makeArray(input).join(sep);
        };
      }
    ]).filter('combine', [
      function() {
        return function() {
          var input, transformer, transformers, value;
          input = arguments[0], transformers = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
          if (!angular.isArray(input)) {
            input = [input];
          }
          return ((function() {
            var _i, _j, _len, _len1, _results;
            _results = [];
            for (_i = 0, _len = input.length; _i < _len; _i++) {
              value = input[_i];
              for (_j = 0, _len1 = transformers.length; _j < _len1; _j++) {
                transformer = transformers[_j];
                if (angular.isFunction(transformer)) {
                  value = transformer(value);
                } else if (typeof transformer === 'string') {
                  value = (function() {
                    switch (transformer) {
                      case '=integer':
                        return parseInt(value);
                      case '=float':
                        return parseFloat(value);
                      default:
                        return $.obj.get(value, transformer);
                    }
                  })();
                }
              }
              _results.push(value);
            }
            return _results;
          })()).reduce(function(t, v) {
            return t + v;
          });
        };
      }
    ]).filter('limit', [
      function() {
        return function(input, page, itemsPerPage) {
          var from, to;
          from = (page - 1) * itemsPerPage;
          to = from + itemsPerPage;
          return $.makeArray(input).slice(from, to);
        };
      }
    ]).filter('trimAll', [
      function() {
        return function(input) {
          var _ref;
          if (angular.isArray(input)) {
            return typeof input.trimAll === "function" ? input.trimAll() : void 0;
          } else {
            return input != null ? typeof input.toString === "function" ? (_ref = input.toString()) != null ? typeof _ref.trim === "function" ? _ref.trim() : void 0 : void 0 : void 0 : void 0;
          }
        };
      }
    ]);
  });

}).call(this);

//# sourceMappingURL=arrays.js.map
